package fr.isae.observer;

import org.junit.*;
import static org.junit.Assert.*;

/**
 *  Unit Test for class Observable.
 *
 *
 * Created: Tue Oct 20 13:39:51 2014
 *
 * @author <a href="mailto:garion@isae.fr">Christophe Garion</a>
 * @version 1.0
 */
public class ObservableTest {

    private static class DummyObservable extends Observable {

    }

    private static class DummyObserver extends Observateur {

        private boolean flag;

        DummyObserver() {
            this.flag = false;
        }

        public void miseAJour() {
            this.flag = true;
        }

        boolean isFlagSet() {
            return this.flag;
        }
    }

    private DummyObservable observable1;
    private DummyObservable observable2;
    private DummyObserver   observer1;
    private DummyObserver   observer2;
    private DummyObserver   observer3;
    private DummyObserver   observer4;
    private DummyObserver   observer5;

    /**
     * Setup for the tests. There are 2 observable (observable1 and
     * observable2) and 5 observer (observer1 to observer5). observer1 to
     * observer3 observe observable1 and observer3 to observer5 observe
     * observable2.
     */
    @Before public void setUp() {
        this.observable1 = new DummyObservable();
        this.observable2 = new DummyObservable();

        this.observer1   = new DummyObserver();
        this.observer2   = new DummyObserver();
        this.observer3   = new DummyObserver();
        this.observer4   = new DummyObserver();
        this.observer5   = new DummyObserver();

        this.observable1.inscrire(this.observer1);
        this.observable1.inscrire(this.observer2);
        this.observable1.inscrire(this.observer3);

        this.observable2.inscrire(this.observer3);
        this.observable2.inscrire(this.observer4);
        this.observable2.inscrire(this.observer5);
    }

    /**
     * Test method for avertir for observable1.
     */
    @Test public void testAvertirObservable1() {
        this.initialCheck();

        this.observable1.avertir();

        DummyObserver mustBeTrue[] = { this.observer1,
                                       this.observer2,
                                       this.observer3 };

        DummyObserver mustBeFalse[] = { this.observer4,
                                        this.observer5 };

        checkFlags(mustBeTrue, mustBeFalse);
    }

    /**
     * Test method for avertir for observable2.
     */
    @Test public void testAvertirObservable2() {
        this.initialCheck();

        this.observable2.avertir();

        DummyObserver mustBeTrue[] = { this.observer3,
                                       this.observer4,
                                       this.observer5 };

        DummyObserver mustBeFalse[] = { this.observer1,
                                        this.observer2 };

        checkFlags(mustBeTrue, mustBeFalse);
    }

    /**
     * Test method for observable1 when removing observer2
     * as observer.
     */
    @Test public void testAnnulerObservable1() {
        this.initialCheck();

        this.observable1.annuler(this.observer2);
        this.observable1.avertir();

        DummyObserver mustBeTrue[] = { this.observer1,
                                       this.observer3 };

        DummyObserver mustBeFalse[] = { this.observer2,
                                        this.observer4,
                                        this.observer5 };

        checkFlags(mustBeTrue, mustBeFalse);
    }

    private void initialCheck() {
        assertFalse(this.observer1.isFlagSet());
        assertFalse(this.observer2.isFlagSet());
        assertFalse(this.observer3.isFlagSet());
        assertFalse(this.observer4.isFlagSet());
        assertFalse(this.observer5.isFlagSet());
    }

    private void checkFlags(DummyObserver mustBeTrue[],
                            DummyObserver mustBeFalse[]) {
        for (DummyObserver obs : mustBeTrue) {
            assertTrue(obs.isFlagSet());
        }

        for (DummyObserver obs : mustBeFalse) {
            assertFalse(obs.isFlagSet());
        }
    }
}
