package fr.isae.geometry;

import org.junit.*;
import static org.junit.Assert.*;

/**
 *  Unit Test for class Segment.
 *
 *
 * Created: Tue Oct 31 13:39:51 2006
 *
 * @author <a href="mailto:garion@isae.fr">Christophe Garion</a>
 * @version 1.0
 */
public class SegmentTest {
    private Segment s;

    /**
     * Setup for the tests.
     */
    @Before public void setUp() {
        this.s = new Segment(new Point(1.0, 2.5), new Point(0.0, -3.0));
    }

    /**
     * Cleanup for the tests.
     */
    @After public void tearDown() {
    }

    /**
     * Test method for getLongueur.
     */
    @Test public void testLongeur() {
        assertEquals(5.59016994, this.s.getLongueur(), Point.EPS);
        assertEquals((new Point(1, 2.5)).distance(new Point(0, -3)),
                     this.s.getLongueur(), Point.EPS);
    }

    /**
     * Test method for translater.
     */
    @Test public void testTranslater() {
        double l = this.s.getLongueur();
        Point ext1 = this.s.getExtremite1();
        Point ext2 = this.s.getExtremite2();

        Point ext1Old = this.s.getExtremite1().clone();
        Point ext2Old = this.s.getExtremite2().clone();

        this.s.translater(-4, 8);

        assertEquals(ext1Old.getX() - 4, ext1.getX(), Point.EPS);
        assertEquals(ext2Old.getX() - 4, ext2.getX(), Point.EPS);
        assertEquals(ext1Old.getY() + 8, ext1.getY(), Point.EPS);
        assertEquals(ext2Old.getY() + 8, ext2.getY(), Point.EPS);
        assertEquals(l, s.getLongueur(), Point.EPS);
    }

    /**
     * Test method for toString.
     */
    @Test public void testToString() {
        assertEquals("[(1.0,2.5);(0.0,-3.0)]", s.toString());
    }
}
