package fr.isae.geometry;

import org.junit.*;
import static org.junit.Assert.*;

/**
 *  Unit Test for class Point.
 *
 *
 * Created: Mon Oct 30 16:30:12 2006
 *
 * @author <a href="mailto:garion@isae.fr">Christophe Garion</a>
 * @version 1.0
 */
public class PointTest {

    private Point p1;
    private Point p2;

    private static final double EPS = 1E-9;

    /**
     * Setup for the tests.
     */
    @Before public void setUp() {
        p1 = this.createPoint(0.0, 0.0);
        p2 = this.createPoint(5.0, 6.0);
    }

    /**
     * Cleanup for the tests.
     */
    @After public void tearDown() {

    }

    /**
     * Factory method for Point.
     *
     * @param x l'abscisse du point
     * @param y l'ordonnee du point
     * @return un point de coordonnees (x, y)
     */
    protected Point createPoint(double x, double y) {
        return new Point(x, y);
    }

    /**
     * Basic test for translater.
     */
    @Test public void testTranslaterBasic() {
        p2.translater(3.0, 6.0);
        assertEquals(8.0, p2.getX(), EPS);
        assertEquals(12.0, p2.getY(), EPS);
    }

    /**
     * Test for translater with null vector.
     */
    @Test public void testTranslaterNullVector() {
        p2.translater(0.0, 0.0);
        assertEquals(5.0, p2.getX(), EPS);
        assertEquals(6.0, p2.getY(), EPS);
    }

    /**
     * Test for translater: going back!
     */
    @Test public void testTranslaterBack() {
        Point pold = p2.clone();
        p2.translater(2.0, 3.0);
        p2.translater(-2.0, -3.0);
        assertEquals(pold.getX(), p2.getX(), EPS);
        assertEquals(pold.getY(), p2.getY(), EPS);
    }

    /**
     * Test method for distance.
     */
    @Test public void testDistance() {
        assertEquals(7.810249676, p1.distance(p2), EPS);
    }

    /**
     * Test method for equals.
     */
    @Test public void testEquals() {
        assertTrue(p1.equals(p1));
        assertFalse(p1.equals(p2));
        assertFalse(p2.equals(p1));

        p2.setX(p1.getX());
        p2.setY(p1.getY());

        assertTrue(p1.equals(p2));
        assertTrue(p2.equals(p1));

        assertFalse(p1.equals(new Object()));
        assertFalse(p1.equals(new java.util.ArrayList<Point>()));
        assertFalse(p1.equals(null));
    }
}
