package fr.isae.observer;

import java.util.ArrayList;

/**
 * <code>Observable</code> est une classe representant un type
 * d'objets pouvant prevenir d'autres objets d'une mise a jour de
 * son etat.
 *
 * @author <a href="mailto:garion@isae.fr">Christophe Garion</a>
 * @version 1.0
 */
public class Observable {

    private ArrayList<Observateur> obs;

    /**
     * Creer un nouvel observable avec une liste d'observateurs vide.
     */
    public Observable() {
        this.obs = new ArrayList<Observateur>();
    }

    /**
     * <code>inscrire</code> permet d'ajouter un observateur a la
     *  liste des observateurs de l'objet.
     *
     * @param o un <code>Observateur</code> a ajouter
     */
    public void inscrire(Observateur o) {
        this.obs.add(o);
    }

    /**
     * <code>annuler</code> permet de retirer un observateur de la
     * liste des observateurs de l'objet.
     *
     * @param o un <code>Observateur</code> a retirer
     */
    public void annuler(Observateur o) {
        this.obs.remove(o);
    }

    /**
     * <code>avertir</code> permet d'avertir tous les observateurs
     *  de l'objet d'une mise a jour.
     *
     */
    protected void avertir() {
        for (Observateur o : this.obs) {
            o.miseAJour();
        }
    }
}
