package fr.isae.geometry.api;

/**
 * <code>TestFigure</code> est une classe applicative pour les classes
 * <code>Segment</code> et <code>Cercle</code>. Elle permet de montrer
 * que les observateurs fonctionnent.
 *
 * @author <a href="mailto:garion@isae.fr">Christophe Garion</a>
 * @version 1.0
 */
public class TestFigures {

    /**
     * Programme permettant de "verifier" si la longueur d'un
     * segment ne change pas lors de la translation d'un des points
     * ayant servi a le creer ou si la translation d'un point ayant
     * servi a creer un cercle a bien les bonnes consequences.
     *
     * @param args non utilise ici
     */
    public static void main(String[] args) {
        Point p1 = new Point(0.0, 0.0);
        Point p2 = new Point(5.0, 0.0);
        Segment s = new Segment(p1, p2);
        Cercle c = new Cercle(p1, p2);

        System.out.print("p2 = ");
        p2.afficher();
        System.out.print("s = ");
        s.afficher();
        System.out.println("longueur de s = " + s.getLongueur());
        System.out.print("c = ");
        c.afficher();
        System.out.println();

        p2.translater(-2.0, 0.0);

        System.out.print("p2 = ");
        p2.afficher();
        System.out.print("s = ");
        s.afficher();
        System.out.println("longueur de s = " + s.getLongueur());
        System.out.print("c = ");
        c.afficher();
        System.out.println();

        p1.translater(2.0, 3.0);

        System.out.print("p1 = ");
        p1.afficher();
        System.out.print("c = ");
        c.afficher();
        System.out.println();

        p2.translater(2.0, 3.0);

        System.out.print("p2 = ");
        p2.afficher();
        System.out.print("c = ");
        c.afficher();
    }
}
