package fr.isae.geometry.api;

import java.util.Observable;
import java.util.Observer;

/**
 * <code>Cercle</code> est une classe permettant de modeliser un
 * cercle. Le cercle est composé de deux points.
 *
 * @author <a href="mailto:garion@isae.fr">Christophe Garion</a>
 * @version 1.0
 */
public class Cercle implements Observer {

    private Point centre;
    private Point periph;
    private double rayon;

    /**
     * Creer une instance de <code>Cercle</code>.
     *
     * @param centre un point representant le centre du cercle
     * @param periph un point sur la peripherie du cercle
     */
    public Cercle(Point centre, Point periph) {
        this.centre = centre;
        this.centre.addObserver(this);
        this.periph = periph;
        this.periph.addObserver(this);
        this.rayon = this.centre.distance(this.periph);
    }

    /**
     * <code>translater</code> permet de translater le cercle.
     *
     * @param dx l'abscisse du vecteur de translation
     * @param dy l'ordonnee du vecteur de translation
     */
    public void translater(double dx, double dy) {
        this.centre.translater(dx, dy);
        this.periph.translater(dx, dy);
    }

    /**
     * <code>afficher</code> permet d'afficher le cercle.
     */
    public void afficher() {
        System.out.println(this);
    }

    @Override public String toString() {
        return this.centre + " -- " +
            this.periph + " r: " +
            this.rayon;
    }

    @Override public void update(Observable o, Object arg) {
        if (o == this.centre) {
            double[] coordTranslation = (double[]) arg;
            this.periph.translater(coordTranslation[0],
                                   coordTranslation[1]);
        } else if (o == this.periph) {
            this.rayon = this.centre.distance(this.periph);
        }
    }
}
