package fr.isae.geometry;

/**
 * <code>TestSegment</code> est une classe de test pour la classe
 * <code>Segment</code>.
 *
 * @author <a href="mailto:cregut@enseeiht.fr">Xavier Cregut</a>
 * @author <a href="mailto:garion@isae.fr">Christophe Garion</a>
 * @version 1.0
 */
public class TestSegment {

    /**
     * Programme permettant de "verifier" si la longueur d'un
     * segment ne change pas lors de la translation d'un des points
     * ayant servi a le creer.
     *
     * @param args non utilise ici
     */
    public static void main(String[] args) {
        Point p1 = new Point(0.0, 0.0);
        Point p2 = new Point(5.0, 0.0);
        Segment s = new Segment(p1, p2);

        System.out.print("p2 = ");
        p2.afficher();
        System.out.println();
        System.out.print("s = ");
        s.afficher();
        System.out.println();
        System.out.println("longueur de s = " + s.getLongueur());
        System.out.println();

        p2.translater(-2.0, 0.0);

        System.out.print("p2 = ");
        p2.afficher();
        System.out.println();
        System.out.print("s = ");
        s.afficher();
        System.out.println();
        System.out.println("longueur de s = " + s.getLongueur());
    }
}
